﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class A_Record_Record__Loan : PageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if(!this.Page.IsPostBack)
        {
            OfficeManage.BindLoanAccount(ddlLoanAccount);//绑定ddlLoanAccount(借贷账户)
            LoanShow();
        }
    }
    #region 功能栏事件（支出、收入、转账、借贷按钮）
    protected void btnExpenditure_Click(object sender, EventArgs e)//支出记账
    {
        Response.Redirect("Record_Expenditure.aspx");
    }
    protected void btnIncome_Click(object sender, EventArgs e)//收入记账
    {
        Response.Redirect("Record_Income.aspx");
    }
    protected void btnTransfer_Click(object sender, EventArgs e)//转账记账
    {
        Response.Redirect("Record_transfer.aspx");
    }
    protected void btnLoan_Click(object sender, EventArgs e)//借贷记账
    {
        Response.Redirect("Record_ Loan.aspx");
    }
    #endregion
    protected void ddlLoanType_SelectedIndexChanged(object sender, EventArgs e)
    {
        LoanShow();
    }
    #region 借贷页面显示
    /// <summary>
    /// 借贷页面显示
    /// </summary>
    public void LoanShow()
    {
        int loanTypeId = ConvertHelper.GetInteger(ddlLoanType.SelectedValue);//借贷类型id
        trRepaymentDateTime.Visible = false;//还款日行隐藏
        trInterst.Visible = false;//利息行隐藏
        trReplaymentInfo.Visible = false;//还款提醒行隐藏
        if(loanTypeId==1)//借入
        {
            trRepaymentDateTime.Visible = true;//还款日行显示
            spanSellerTdName.InnerHtml = "债权人：";//借贷人td显示
            spanAccountTdName.InnerHtml = "借入账户：";//账户td显示
            trReplaymentInfo.Visible = true;//还款提醒行显示
        }
        else if (loanTypeId == 2)//借出
        {
            trRepaymentDateTime.Visible = true;//还款日行显示
            spanSellerTdName.InnerHtml = "债务人：";//借贷人td显示
            spanAccountTdName.InnerHtml = "借出账户：";//账户td显示
            trReplaymentInfo.Visible = true;//还款提醒行显示
        }
        else if(loanTypeId==3)//收款
        {
            trInterst.Visible = true;//利息行显示
            spanSellerTdName.InnerHtml = "债务人：";//借贷人td显示
            spanAccountTdName.InnerHtml = "收款账户：";//账户td显示
        }
        else if(loanTypeId==4)//还款
        {
            trInterst.Visible = true;//利息行显示
            spanSellerTdName.InnerHtml = "债权人：";//借贷人td显示
            spanAccountTdName.InnerHtml = "还款户：";//账户td显示
        }
    }
    #endregion
    protected void btnSubmit_Click(object sender, EventArgs e)
    {
        #region 获取账户id
        int accountId = 0;//账户ID
        if (uclAccount.AccountTypeID == 1)//现金账户
        {
            accountId = uclAccount.CashAccountID;
        }
        else if (uclAccount.AccountTypeID == 2)//信用卡
        {
            accountId = uclAccount.CreditCardID;
        }
        else if (uclAccount.AccountTypeID == 3)//储蓄卡
        {
            accountId = uclAccount.SavingsCardID;
        }
        else if (uclAccount.AccountTypeID == 4)//网上支付
        {
            accountId = uclAccount.OnlinePayID;
        }
        #endregion
        int loanTypeId = ConvertHelper.GetInteger(ddlLoanType.SelectedValue);//借贷类型id(1-借入，2-借出，3-收款，4-还款)
        int flag = 0;//添加借贷记录的id
        if (loanTypeId == 1 || loanTypeId == 2)//借入或借出（1-借入，2-借出）
        {
            flag = SqlHelper.Operation("INSERT INTO dbo.tabA_Record_Loan(RecordLoanTypeId,RecordLoanMoney,RLOutsideAccountId,RLInsideAccountTypeId,RLInsideAccountId,RLoanDateTime,RLRepaymentDateTime,RLoanInfoWay,RecordLoanRemarks,CreateTime) VALUES(" + ConvertHelper.GetInteger(ddlLoanType.SelectedValue) + "," + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + "," + ConvertHelper.GetInteger(ddlLoanAccount.SelectedValue) + "," + uclAccount.AccountTypeID + "," + accountId + ",'" + ConvertHelper.GetDateTime(txtLoanDateTime.Text.Trim()) + "','" + ConvertHelper.GetDateTime(txtRepaymentDateTime.Text.Trim()) + "',"+ddlReplaymentInfoWay.SelectedValue+",'" + txtLoanRemarks.Text.Trim() + "','" + System.DateTime.Now + "')", "constring");
        }
        else if (loanTypeId == 3 || loanTypeId == 4)//收款或还款（3-收款，4-还款）
        {
            flag = SqlHelper.Operation("INSERT INTO dbo.tabA_Record_Loan(RecordLoanTypeId,RecordLoanMoney,RLOutsideAccountId,RLInsideAccountTypeId,RLInsideAccountId,RLoanDateTime,RLoanInterest,RLoanInfoWay,RecordLoanRemarks,CreateTime) VALUES(" + ConvertHelper.GetInteger(ddlLoanType.SelectedValue) + "," + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + "," + ConvertHelper.GetInteger(ddlLoanAccount.SelectedValue) + "," + uclAccount.AccountTypeID + "," + accountId + ",'" + ConvertHelper.GetDateTime(txtLoanDateTime.Text.Trim()) + "'," + ConvertHelper.GetDecimal(txtInterest.Text.Trim()) + "," + ddlReplaymentInfoWay.SelectedValue + ",'" + txtLoanRemarks.Text.Trim() + "','" + System.DateTime.Now + "')", "constring");
        }
        if (flag > 0)//添加借贷记录成功
        {
            int flagAccount = 0;//修改账户余额id
            if(loanTypeId==1)//借入
            {
                #region 借入修改账户余额
                if (uclAccount.AccountTypeID == 1)//现金账户
                {
                    flagAccount = SqlHelper.Operation("UPDATE dbo.tabA_Account_Cash SET CashRemainder=CashRemainder+" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + " WHERE CashAccountId=" + uclAccount.CashAccountID + "", "constring");//修改现金用户余额
                }
                else if (uclAccount.AccountTypeID == 2)//信用卡账户(cardArrears:欠款金额)
                {
                    flagAccount = SqlHelper.Operation("UPDATE dbo.tabA_Account_CreditCard SET CardArrears=CardArrears-" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + " WHERE CreditCardId=" + uclAccount.CreditCardID + "", "constring");//修改信用卡账户欠款金额
                }
                else if (uclAccount.AccountTypeID == 3)//储蓄卡账户
                {
                    flagAccount = SqlHelper.Operation("UPDATE dbo.tabA_Account_SavingsCard SET SavingsCardRemainder=SavingsCardRemainder+" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + " WHERE SavingsCardId=" + uclAccount.SavingsCardID + "", "constring");//修改储蓄卡账户余额
                }
                else if (uclAccount.AccountTypeID == 4)//网上支付账户
                {
                    flagAccount = SqlHelper.Operation("UPDATE dbo.tabA_Account_OnlinePay SET OnlinePayRemainder=OnlinePayRemainder+" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + " WHERE OnlinePayId=" + uclAccount.OnlinePayID + "", "constring");//修改网上支付账户余额
                }
                #endregion
            }
            else if(loanTypeId==2)//借出
            {
                #region 借出修改账户余额
                if (uclAccount.AccountTypeID == 1)//现金账户
                {
                    flagAccount = SqlHelper.Operation("UPDATE dbo.tabA_Account_Cash SET CashRemainder=CashRemainder-" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + " WHERE CashAccountId=" + uclAccount.CashAccountID + "", "constring");//修改现金用户余额
                }
                else if (uclAccount.AccountTypeID == 2)//信用卡账户(cardArrears:欠款金额)
                {
                    flagAccount = SqlHelper.Operation("UPDATE dbo.tabA_Account_CreditCard SET CardArrears=CardArrears+" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + " WHERE CreditCardId=" + uclAccount.CreditCardID + "", "constring");//修改信用卡账户欠款金额
                }
                else if (uclAccount.AccountTypeID == 3)//储蓄卡账户
                {
                    flagAccount = SqlHelper.Operation("UPDATE dbo.tabA_Account_SavingsCard SET SavingsCardRemainder=SavingsCardRemainder-" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + " WHERE SavingsCardId=" + uclAccount.SavingsCardID + "", "constring");//修改储蓄卡账户余额
                }
                else if (uclAccount.AccountTypeID == 4)//网上支付账户
                {
                    flagAccount = SqlHelper.Operation("UPDATE dbo.tabA_Account_OnlinePay SET OnlinePayRemainder=OnlinePayRemainder-" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + " WHERE OnlinePayId=" + uclAccount.OnlinePayID + "", "constring");//修改网上支付账户余额
                }
                #endregion
            }
            else if(loanTypeId==3)//收款（加上(借贷金额+利息)）
            {
                #region 收款修改账户余额
                if (uclAccount.AccountTypeID == 1)//现金账户
                {
                    flagAccount = SqlHelper.Operation("UPDATE dbo.tabA_Account_Cash SET CashRemainder=CashRemainder+" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + "+"+ConvertHelper.GetDecimal(txtInterest.Text.Trim())+" WHERE CashAccountId=" + uclAccount.CashAccountID + "", "constring");//修改现金用户余额
                }
                else if (uclAccount.AccountTypeID == 2)//信用卡账户(cardArrears:欠款金额)
                {
                    flagAccount = SqlHelper.Operation("UPDATE dbo.tabA_Account_CreditCard SET CardArrears=CardArrears-" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + "-" + ConvertHelper.GetDecimal(txtInterest.Text.Trim()) + " WHERE CreditCardId=" + uclAccount.CreditCardID + "", "constring");//修改信用卡账户欠款金额
                }
                else if (uclAccount.AccountTypeID == 3)//储蓄卡账户
                {
                    flagAccount = SqlHelper.Operation("UPDATE dbo.tabA_Account_SavingsCard SET SavingsCardRemainder=SavingsCardRemainder+" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + "+" + ConvertHelper.GetDecimal(txtInterest.Text.Trim()) + " WHERE SavingsCardId=" + uclAccount.SavingsCardID + "", "constring");//修改储蓄卡账户余额
                }
                else if (uclAccount.AccountTypeID == 4)//网上支付账户
                {
                    flagAccount = SqlHelper.Operation("UPDATE dbo.tabA_Account_OnlinePay SET OnlinePayRemainder=OnlinePayRemainder+" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + "+" + ConvertHelper.GetDecimal(txtInterest.Text.Trim()) + " WHERE OnlinePayId=" + uclAccount.OnlinePayID + "", "constring");//修改网上支付账户余额
                }
                #endregion
            }
            else if(loanTypeId==4)//还款（减去（借贷金额+利息））
            {
                #region 还款修改账户余额
                if (uclAccount.AccountTypeID == 1)//现金账户
                {
                    flagAccount = SqlHelper.Operation("UPDATE dbo.tabA_Account_Cash SET CashRemainder=CashRemainder-" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + "-" + ConvertHelper.GetDecimal(txtInterest.Text.Trim()) + " WHERE CashAccountId=" + uclAccount.CashAccountID + "", "constring");//修改现金用户余额
                }
                else if (uclAccount.AccountTypeID == 2)//信用卡账户(cardArrears:欠款金额)
                {
                    flagAccount = SqlHelper.Operation("UPDATE dbo.tabA_Account_CreditCard SET CardArrears=CardArrears+" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + "+" + ConvertHelper.GetDecimal(txtInterest.Text.Trim()) + " WHERE CreditCardId=" + uclAccount.CreditCardID + "", "constring");//修改信用卡账户欠款金额
                }
                else if (uclAccount.AccountTypeID == 3)//储蓄卡账户
                {
                    flagAccount = SqlHelper.Operation("UPDATE dbo.tabA_Account_SavingsCard SET SavingsCardRemainder=SavingsCardRemainder-" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + "-" + ConvertHelper.GetDecimal(txtInterest.Text.Trim()) + " WHERE SavingsCardId=" + uclAccount.SavingsCardID + "", "constring");//修改储蓄卡账户余额
                }
                else if (uclAccount.AccountTypeID == 4)//网上支付账户
                {
                    flagAccount = SqlHelper.Operation("UPDATE dbo.tabA_Account_OnlinePay SET OnlinePayRemainder=OnlinePayRemainder-" + ConvertHelper.GetDecimal(txtLoanMoney.Text.Trim()) + "-" + ConvertHelper.GetDecimal(txtInterest.Text.Trim()) + " WHERE OnlinePayId=" + uclAccount.OnlinePayID + "", "constring");//修改网上支付账户余额
                }
                #endregion
            }
            if (flagAccount > 0)//借入、借出、收款、还款修改账户余额成功
            {
                ScriptHelper.AlertMessage(this.Page, "添加成功！");
                LoanClear();
            }
            else//借入、借出、收款、还款修改账户余额失败，删除刚添加的借贷记录
            {
                SqlHelper.Operation("DELECT FROM dbo.tabA_Record_Loan WHERE RecordLoanId=" + flag + "", "constring");//删除刚添加的借贷记录
                ScriptHelper.AlertMessage(this.Page,"添加失败，请联系管理员！");
            }
        }
        else
        {
            ScriptHelper.AlertMessage(this.Page, "添加失败，请联系管理员！");
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)//取消事件
    {
        LoanClear();
    }
    /// <summary>
    /// 借贷重置
    /// </summary>
    public void LoanClear()
    {
        ddlLoanType.SelectedValue = "1";//借贷类型为1（借入）
        txtLoanMoney.Text = "";//借贷金额
        OfficeManage.BindDdlSeller(ddlLoanAccount);//绑定借贷账户
        uclAccount.AccountTypeID = 1;//账户类型id变为1（现金账户）
        uclAccount.CashAccountID = 0;//账户
        txtLoanDateTime.Text = "";//借贷时间
        txtRepaymentDateTime.Text = "";//还款日期
        txtInterest.Text = "";//利息
        txtLoanRemarks.Text = "";//借贷备注
    }
}